/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

// This needed a bit of work to get it to behave. The problem was found to be
// due the original not initialising o, but I cleaned up more anyway. TheEmu.

void mainImage( inout vec4 o, vec2 p )
 {
   p /= iResolution.xy;
   float s = 0.0;
   o = vec4(0.0,0.0,0.0,1.0);
   for (float i=-3.; i<= 3.; i++)
    { float t = fract(iGlobalTime) - i;  
      float a = 0.5 + 0.5*cos(t);  
      t *= 0.6*smoothstep(0.0,1.0,length(p-0.5));     
      float C = cos(t); 
      float S = sin(t);
      o += a*texture2D(iChannel0,mat2(C,S,-S,C)*(p-.5)+.1*iGlobalTime);
      s += a;  
    } 
   o = 2.0*o/s - .5;
}

void main ( void )
 { mainImage ( gl_FragColor, gl_FragCoord.xy );
 }
